/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.waypoints.render;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.effect.Effects;
import xaero.common.interfaces.render.InterfaceRenderer;
import xaero.common.minimap.element.render.MinimapElementRenderer;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.minimap.waypoints.render.WaypointDeleter;
import xaero.common.minimap.waypoints.render.WaypointFilterParams;
import xaero.common.minimap.waypoints.render.WaypointGuiRenderContext;
import xaero.common.minimap.waypoints.render.WaypointReader;
import xaero.common.minimap.waypoints.render.WaypointRenderProvider;
import xaero.common.settings.ModSettings;

public final class WaypointsGuiRenderer
extends MinimapElementRenderer<Waypoint, WaypointGuiRenderContext> {
    private final IXaeroMinimap modMain;
    private final WaypointDeleter waypointReachDeleter;

    private WaypointsGuiRenderer(IXaeroMinimap modMain, WaypointReader elementReader, WaypointRenderProvider provider, WaypointGuiRenderContext context, WaypointDeleter waypointReachDeleter) {
        super(elementReader, provider, context);
        this.modMain = modMain;
        this.waypointReachDeleter = waypointReachDeleter;
    }

    @Override
    public boolean renderElement(int location, boolean highlit, boolean outOfBounds, FontRenderer font, Framebuffer framebuffer, MinimapRendererHelper helper, Entity renderEntity, EntityPlayer player, double renderX, double renderY, double renderZ, int elementIndex, double optionalDepth, float optionalScale, Waypoint w, double partialX, double partialY, boolean cave, float partialTicks, ScaledResolution scaledRes) {
        if (((WaypointGuiRenderContext)this.context).deleteReachedDeathpoints && w.isOneoffDestination() && System.currentTimeMillis() - w.getCreatedAt() > 5000L) {
            double correctOffZ;
            double correctDistance;
            double correctOffX = renderX - (double)w.getX(((WaypointGuiRenderContext)this.context).dimDiv);
            double correctOffY = renderY - (double)w.getY();
            if (!w.isYIncluded()) {
                correctOffY = 0.0;
            }
            if ((correctDistance = Math.sqrt(correctOffX * correctOffX + correctOffY * correctOffY + (correctOffZ = renderZ - (double)w.getZ(((WaypointGuiRenderContext)this.context).dimDiv)) * correctOffZ)) < 4.0) {
                this.waypointReachDeleter.add(w);
            }
        }
        GlStateManager.func_179137_b((double)-1.0, (double)-1.0, (double)optionalDepth);
        GlStateManager.func_179152_a((float)optionalScale, (float)optionalScale, (float)1.0f);
        this.drawIconOnGUI(helper, w, ((WaypointGuiRenderContext)this.context).settings, 0, 0);
        return true;
    }

    @Override
    public void preRender(int location, Entity renderEntity, EntityPlayer player, double renderX, double renderY, double renderZ, ScaledResolution scaledRes, IXaeroMinimap modMain) {
        ((WaypointGuiRenderContext)this.context).settings = modMain.getSettings();
        ((WaypointGuiRenderContext)this.context).deleteReachedDeathpoints = modMain.getSettings().deleteReachedDeathpoints;
        GlStateManager.func_179141_d();
        Waypoint.RENDER_SORTING_POS = ActiveRenderInfo.getCameraPosition().func_72441_c(renderX, renderY, renderZ);
        this.updateWaypointCollection(renderX, renderY, renderZ, modMain);
    }

    @Override
    public void postRender(int location, Entity renderEntity, EntityPlayer player, double renderX, double renderY, double renderZ, ScaledResolution scaledRes, IXaeroMinimap modMain) {
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
        this.waypointReachDeleter.deleteCollected(waypointsManager.getCurrentWorld(), modMain.getSettings().renderAllSets);
    }

    public void updateWaypointCollection(double renderX, double renderY, double renderZ, IXaeroMinimap modMain) {
        Hashtable<String, Hashtable<Integer, Waypoint>> customWaypoints;
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
        List<Waypoint> sortingList = ((WaypointGuiRenderContext)this.context).sortingList;
        sortingList.clear();
        if (waypointsManager.getWaypoints() != null) {
            if (modMain.getSettings().renderAllSets) {
                HashMap<String, WaypointSet> sets = waypointsManager.getCurrentWorld().getSets();
                for (Map.Entry<String, WaypointSet> setEntry : sets.entrySet()) {
                    sortingList.addAll(setEntry.getValue().getList());
                }
            } else {
                sortingList.addAll(waypointsManager.getWaypoints().getList());
            }
        }
        if (!(customWaypoints = WaypointsManager.customWaypoints).isEmpty()) {
            for (Hashtable<Integer, Waypoint> modCustomWaypoints : customWaypoints.values()) {
                sortingList.addAll(modCustomWaypoints.values());
            }
        }
        this.waypointReachDeleter.begin();
        ((WaypointGuiRenderContext)this.context).dimDiv = waypointsManager.getDimensionDivision(waypointsManager.getCurrentContainerID());
        ((WaypointGuiRenderContext)this.context).filterParams.setParams(renderX, renderY, renderZ, 0.0, 0.0, 0.0, null, ((WaypointGuiRenderContext)this.context).dimDiv, modMain.getSettings().getDeathpoints(), modMain.getSettings().getMaxWaypointsDistance(), modMain.getSettings().waypointsDistanceMin, 0.0);
    }

    public void drawIconOnGUI(MinimapRendererHelper rendererHelper, Waypoint w, ModSettings settings, int drawX, int drawY) {
        int c = ModSettings.COLORS[w.getColor()];
        int r = c >> 16 & 0xFF;
        int g = c >> 8 & 0xFF;
        int b = c & 0xFF;
        int a = (int)(255.0f * ((float)settings.waypointOpacityMap / 100.0f));
        c = a << 24 | r << 16 | g << 8 | b;
        int j = w.getWaypointType() == 1 ? 4 : Minecraft.func_71410_x().field_71466_p.func_78256_a(w.getSymbol()) / 2;
        int addedFrame = j > 4 ? j - 4 : 0;
        int rectX1 = drawX - 4 - addedFrame;
        int rectY1 = drawY - 4 - addedFrame;
        int rectX2 = drawX + 5 + addedFrame;
        int rectY2 = drawY + 5 + addedFrame;
        Gui.func_73734_a((int)rectX1, (int)rectY1, (int)rectX2, (int)rectY2, (int)c);
        if (w.getWaypointType() != 1) {
            GlStateManager.func_179097_i();
            Minecraft.func_71410_x().field_71466_p.func_175063_a(w.getSymbol(), (float)(drawX + 1 - j), (float)(drawY - 3), -1);
        } else {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(InterfaceRenderer.guiTextures);
            GlStateManager.func_179131_c((float)0.2431f, (float)0.2431f, (float)0.2431f, (float)1.0f);
            Minecraft.func_71410_x().field_71456_v.func_73729_b(rectX1 + 1, rectY1 + 1, 0, 78, 9, 9);
            GlStateManager.func_179131_c((float)0.9882f, (float)0.9882f, (float)0.9882f, (float)1.0f);
            Minecraft.func_71410_x().field_71456_v.func_73729_b(rectX1, rectY1, 0, 78, 9, 9);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public void drawSetChange(WaypointsManager waypointsManager, ScaledResolution res) {
        if (waypointsManager.getWaypoints() != null && waypointsManager.setChanged != 0L) {
            int passed = (int)(System.currentTimeMillis() - waypointsManager.setChanged);
            if (passed < 1500) {
                int fadeTime = 300;
                boolean fading = passed > 1500 - fadeTime;
                int alpha = 3 + (int)(252.0f * (fading ? (float)(1500 - passed) / (float)fadeTime : 1.0f));
                int c = 0xFFFFFF | alpha << 24;
                GlStateManager.func_179097_i();
                Minecraft.func_71410_x().field_71456_v.func_73732_a(Minecraft.func_71410_x().field_71466_p, I18n.func_135052_a((String)waypointsManager.getWaypoints().getName(), (Object[])new Object[0]), res.func_78326_a() / 2, res.func_78328_b() / 2 + 50, c);
                GlStateManager.func_179141_d();
                GlStateManager.func_179147_l();
                GlStateManager.func_179112_b((int)770, (int)771);
            } else {
                waypointsManager.setChanged = 0L;
            }
        }
    }

    @Override
    public boolean shouldRender(int location) {
        return (location != 1 && location != 0 || this.modMain.getSettings().getShowWaypoints()) && !Minecraft.func_71410_x().field_71439_g.func_70644_a(Effects.NO_WAYPOINTS) && !Minecraft.func_71410_x().field_71439_g.func_70644_a(Effects.NO_WAYPOINTS_BENEFICIAL) && !Minecraft.func_71410_x().field_71439_g.func_70644_a(Effects.NO_WAYPOINTS_HARMFUL);
    }

    @Override
    public int getOrder() {
        return 1;
    }

    public static final class Builder {
        private WaypointDeleter waypointDeleter;
        private final IXaeroMinimap modMain;

        private Builder(IXaeroMinimap modMain) {
            this.modMain = modMain;
        }

        private Builder setDefault() {
            this.setWaypointDeleter(null);
            return this;
        }

        public Builder setWaypointDeleter(WaypointDeleter waypointDeleter) {
            this.waypointDeleter = waypointDeleter;
            return this;
        }

        public WaypointsGuiRenderer build() {
            if (this.waypointDeleter == null) {
                throw new IllegalStateException();
            }
            final WaypointGuiRenderContext context = new WaypointGuiRenderContext();
            context.filter = new Predicate<Waypoint>(){

                @Override
                public boolean test(Waypoint w) {
                    WaypointFilterParams filterParams = context.filterParams;
                    boolean deathpoints = filterParams.deathpoints;
                    if (w.isDisabled() || (w.getWaypointType() == 1 || w.getWaypointType() == 2) && !deathpoints) {
                        return false;
                    }
                    double offx = (double)w.getX(filterParams.dimDiv) + 0.5 - filterParams.cameraX;
                    double offz = (double)w.getZ(filterParams.dimDiv) + 0.5 - filterParams.cameraZ;
                    double distance = Math.sqrt(offx * offx + offz * offz);
                    double waypointsDistance = filterParams.waypointsDistance;
                    return w.isOneoffDestination() || w.getWaypointType() == 1 || w.isGlobal() || waypointsDistance == 0.0 || !(distance > waypointsDistance);
                }
            };
            return new WaypointsGuiRenderer(this.modMain, new WaypointReader(), new WaypointRenderProvider(), context, this.waypointDeleter);
        }

        public static Builder begin(IXaeroMinimap modMain) {
            return new Builder(modMain).setDefault();
        }
    }
}

